var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import fs from 'node:fs/promises';
import path from 'node:path';
import Handlebars from 'handlebars';
import { RepomixError } from '../../shared/errorHandle.js';
import { searchFiles } from '../file/fileSearch.js';
import { generateTreeString } from '../file/fileTreeGenerate.js';
import { generateHeader, generateSummaryFileFormat, generateSummaryNotes, generateSummaryPurpose, generateSummaryUsageGuidelines, } from './outputStyleDecorate.js';
import { getMarkdownTemplate } from './outputStyles/markdownStyle.js';
import { getPlainTemplate } from './outputStyles/plainStyle.js';
import { getXmlTemplate } from './outputStyles/xmlStyle.js';
const createRenderContext = (outputGeneratorContext) => {
    return {
        generationHeader: generateHeader(outputGeneratorContext.generationDate),
        summaryPurpose: generateSummaryPurpose(),
        summaryFileFormat: generateSummaryFileFormat(),
        summaryUsageGuidelines: generateSummaryUsageGuidelines(outputGeneratorContext.config, outputGeneratorContext.instruction),
        summaryNotes: generateSummaryNotes(outputGeneratorContext.config),
        headerText: outputGeneratorContext.config.output.headerText,
        instruction: outputGeneratorContext.instruction,
        treeString: outputGeneratorContext.treeString,
        processedFiles: outputGeneratorContext.processedFiles,
        fileSummaryEnabled: outputGeneratorContext.config.output.fileSummary,
        directoryStructureEnabled: outputGeneratorContext.config.output.directoryStructure,
    };
};
export const generateOutput = (rootDir, config, processedFiles, allFilePaths) => __awaiter(void 0, void 0, void 0, function* () {
    const outputGeneratorContext = yield buildOutputGeneratorContext(rootDir, config, allFilePaths, processedFiles);
    const renderContext = createRenderContext(outputGeneratorContext);
    let template;
    switch (config.output.style) {
        case 'xml':
            template = getXmlTemplate();
            break;
        case 'markdown':
            template = getMarkdownTemplate();
            break;
        default:
            template = getPlainTemplate();
    }
    const compiledTemplate = Handlebars.compile(template);
    return `${compiledTemplate(renderContext).trim()}\n`;
});
export const buildOutputGeneratorContext = (rootDir, config, allFilePaths, processedFiles) => __awaiter(void 0, void 0, void 0, function* () {
    let repositoryInstruction = '';
    if (config.output.instructionFilePath) {
        const instructionPath = path.resolve(config.cwd, config.output.instructionFilePath);
        try {
            repositoryInstruction = yield fs.readFile(instructionPath, 'utf-8');
        }
        catch (_a) {
            throw new RepomixError(`Instruction file not found at ${instructionPath}`);
        }
    }
    let emptyDirPaths = [];
    if (config.output.includeEmptyDirectories) {
        try {
            const searchResult = yield searchFiles(rootDir, config);
            emptyDirPaths = searchResult.emptyDirPaths;
        }
        catch (error) {
            if (error instanceof Error) {
                throw new RepomixError(`Failed to search for empty directories: ${error.message}`);
            }
        }
    }
    return {
        generationDate: new Date().toISOString(),
        treeString: generateTreeString(allFilePaths, emptyDirPaths),
        processedFiles,
        config,
        instruction: repositoryInstruction,
    };
});
//# sourceMappingURL=outputGenerate.js.map